*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file updated for Nids Wave 5

* THIS IS THE 8th INCOME DO FILE - RELEASE DO FILE: 7 OF 7
* THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

*=====================================================================================================================================

* OPENING DATASET CREATED IN DO FILE "Income - Aggregation of post-imputation variables (6 of 7)"

use "$DataOUT\hhdata.dta", clear

foreach var of varlist hhq_incb fwag cwag swag cheq prof extr bonu othe help  ///
ppen uif comp indi inhe rnt retr brid gift loan sale remt {
rename `var'_data `var'_flg
}

keep pid w5_hhid hhsizer hhincome* hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag_imp cwag_imp swag_imp ///
cheq_imp prof_imp extr_imp bonu_imp othe_imp help_imp spen ppen_imp uif comp_imp dis ///
chld fost cdep indi_imp inhe_imp rnt_imp retr_imp brid_imp gift_imp loan_imp sale_imp remt_imp fwag_flg ///
cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg ///
dis_flg chld_flg fost_flg cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg ///
remt_flg 
sort w5_hhid

rename *_imp * 

*Renaming 
foreach x of varlist hhsizer hhincome hhincome_flg hhq_inc hhq_incb hhq_incb_flg hhagric ///
hhwage hhgovt hhother hhinvest hhcapital hhremitt hhimprent hhimprent_flg pi_hhincome ///
pi_hhagric pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhcapital pi_hhremitt pi_hhimprent fwag cwag swag ///
cheq prof extr bonu othe help  spen ppen uif comp dis chld fost cdep indi inhe ///
rnt retr brid gift loan sale remt ///
fwag_flg cwag_flg swag_flg cheq_flg prof_flg extr_flg bonu_flg ///
othe_flg help_flg spen_flg ppen_flg uif_flg comp_flg dis_flg chld_flg fost_flg ///
cdep_flg indi_flg inhe_flg rnt_flg retr_flg brid_flg gift_flg loan_flg sale_flg remt_flg {
rename `x' w5_`x'
}

save "$DataOUT\temp.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* HOUSEHOLD LEVEL RELEASE

use "$DataOUT\temp.dta", clear
keep w5_hhid w5_hhsizer w5_hhq_inc w5_hhq_incb w5_hhq_incb_flg w5_hhincome ///
w5_hhincome_flg w5_hhwage w5_hhgovt w5_hhother w5_hhinvest w5_hhcapital w5_hhremitt ///
w5_hhimprent w5_hhimprent_flg w5_hhagric w5_pi_hhincome w5_pi_hhwage w5_pi_hhgovt ///
w5_pi_hhother w5_pi_hhinvest w5_pi_hhcapital w5_pi_hhremitt w5_pi_hhagric w5_pi_hhimprent
sort w5_hhid w5_hhsizer
drop if w5_hhid==w5_hhid[_n-1]

sort w5_hhid
save "$DataOUT\release.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* INDIVIDUAL LEVEL RELEASE

use "$DataOUT\temp.dta", clear

keep pid w5_hhid w5_fwag w5_cwag w5_swag w5_cheq w5_prof w5_extr w5_bonu w5_othe ///
w5_help w5_spen w5_ppen w5_uif w5_comp w5_dis w5_chld w5_fost w5_cdep w5_indi w5_inhe ///
w5_rnt w5_retr w5_brid w5_gift w5_loan w5_sale w5_remt w5_fwag_flg w5_cwag_flg w5_swag_flg ///
w5_cheq_flg w5_prof_flg w5_extr_flg w5_bonu_flg w5_othe_flg w5_help_flg w5_spen_flg ///
w5_ppen_flg w5_uif_flg w5_comp_flg w5_dis_flg w5_chld_flg w5_fost_flg w5_cdep_flg w5_indi_flg ///
w5_inhe_flg w5_rnt_flg w5_retr_flg w5_brid_flg w5_gift_flg w5_loan_flg w5_sale_flg w5_remt_flg

order pid w5_hhid w5_fwag w5_cwag w5_swag w5_cheq w5_prof w5_extr w5_bonu w5_othe w5_help ///
w5_spen w5_ppen w5_uif w5_comp w5_dis w5_chld w5_fost w5_cdep w5_indi w5_inhe w5_rnt w5_retr ///
w5_brid w5_gift w5_loan w5_sale w5_remt w5_fwag_flg w5_cwag_flg w5_swag_flg w5_cheq_flg ///
w5_prof_flg w5_extr_flg w5_bonu_flg w5_othe_flg w5_help_flg w5_spen_flg w5_ppen_flg ///
w5_uif_flg w5_comp_flg w5_dis_flg w5_chld_flg w5_fost_flg w5_cdep_flg w5_indi_flg w5_inhe_flg ///
w5_rnt_flg w5_retr_flg w5_brid_flg w5_gift_flg w5_loan_flg w5_sale_flg w5_remt_flg

lab var w5_fwag "Monthly take home pay from primary and secondary jobs"
lab var w5_cwag "Monthly take home pay from casual work"
lab var w5_swag "Monthly income from self-employment"
lab var w5_cheq "Income from 13th cheque"
lab var w5_prof "Income from profit share"
lab var w5_extr "Monthly income from extra payment on a piece-rate basis"
lab var w5_bonu "Income from other bonuses from main job"
lab var w5_othe "Monthly income from other sources"
lab var w5_help "Monthly income from helping friends"
lab var w5_ppen "Monthly income from private/foreign pension and retirement annuities"
lab var w5_uif "Monthly income from UIF payments"
lab var w5_comp "Monthly income from workmen's compensation"
lab var w5_indi "Monthly income from interest and dividends"
lab var w5_inhe "Monthly income from inheritances"
lab var w5_rnt "Monthly income from rentals"
lab var w5_retr "Monthly income from retrenchment payments"
lab var w5_brid "Monthly income from lobola/bridal payments"
lab var w5_gift "Monthly income from gifts"
lab var w5_loan "Monthly 'income' from loan repayments"
lab var w5_sale "Monthly 'income' from sale of household assets"
lab var w5_remt "Monthly income from remittance payments"
lab var w5_fwag_flg "Net wage data flag"
lab var w5_cwag_flg "Casual wage data flag"
lab var w5_swag_flg "Self employment wage data flag"
lab var w5_cheq_flg "13th cheque data flag"
lab var w5_prof_flg "Profit share data flag"
lab var w5_extr_flg "Extra piece-rate payment data flag"
lab var w5_bonu_flg "Bonus income data flag"
lab var w5_othe_flg "Income from other sources data flag"
lab var w5_help_flg "Help income data flag"
lab var w5_ppen_flg "Private pension/retirement annuity data flag"
lab var w5_uif_flg "UIF income data flag"
lab var w5_comp_flg "Workmen's compensation data flag"
lab var w5_indi_flg "Interest and dividend income data flag"
lab var w5_inhe_flg "Inheritance income data flag"
lab var w5_rnt_flg "Rental income data flag"
lab var w5_retr_flg "Retrenchment income data flag"
lab var w5_brid_flg "Lobola/bridal income data flag"
lab var w5_gift_flg "Gift income data flag"
lab var w5_loan_flg "Loan repayment income data flag"
lab var w5_sale_flg "Sale of household assets data flag"
lab var w5_remt_flg "Remittance income data flag"

sort pid
save "$DataOUT\release_indiv.dta", replace

*----------------------------------------------------------------------------------------------------------------------------------------------

* FINAL RELEASE FILES

clear
use "$DataOUT\temp.dta", clear

sort w5_hhid
merge m:1 w5_hhid using "$DataOUT\release.dta"
drop _merge
sort w5_hhid
drop if w5_hhid==w5_hhid[_n-1]
compress

keep w5_hhid w5_hhsizer w5_hhq_inc w5_hhq_incb w5_hhq_incb_flg w5_hhincome w5_hhincome_flg ///
w5_hhwage w5_hhgovt w5_hhother w5_hhinvest w5_hhcapital w5_hhremitt w5_hhimprent w5_hhimprent_flg ///
w5_pi_hhincome w5_pi_hhwage w5_pi_hhgovt w5_pi_hhother w5_pi_hhinvest w5_pi_hhcapital ///
w5_pi_hhremitt w5_pi_hhagric w5_hhagric w5_pi_hhimprent

order w5_hhid  /*w5_hhprov w5_hhgeo w5_hhdc w5_hhcluster w5_wgt w5_dwgt w5_wgt_p1 w5_dwgt_p1 w5_dtwgt_p1*/ ///
/*w5_dtwgt*/ w5_hhsizer w5_hhq_inc w5_hhq_incb w5_hhq_incb_flg w5_hhincome w5_hhincome_flg ///
w5_hhwage w5_hhgovt w5_hhother w5_hhinvest w5_hhcapital w5_hhremitt w5_hhimprent w5_hhimprent_flg ///
w5_hhagric w5_pi_hhincome w5_pi_hhwage w5_pi_hhgovt w5_pi_hhother w5_pi_hhinvest w5_pi_hhcapital ///
w5_pi_hhremitt w5_pi_hhagric w5_pi_hhimprent

lab var w5_hhq_incb_flg "The household income as per household questionnaire data"
lab var w5_hhagric "Household average monthly income from subsistence agriculture"

compress
save "$DataOUT\hhderived_INCOME", replace
erase "$DataOUT\temp.dta"

*Individual derived

use "$DataOUT\release_indiv.dta", clear
order pid w5_hhid
compress
duplicates drop pid, force
save "$DataOUT\indderived_INCOME", replace

/*
erase "$DataOUT\data.dta"
capture erase "$DataOUT\temp.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\hhdata.dta"
erase "$DataOUT\release.dta"
erase "$DataOUT\release_indiv.dta"

* end of do file
*==================================================================================================================================================

